<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Admin extends Model 
{

    protected $table = 'admins';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function areas()
    {
        return $this->hasMany('App\Models\Area');
    }

    public function specializations()
    {
        return $this->hasMany('App\Models\Specialization');
    }

    public function users()
    {
        return $this->hasMany('App\Models\User');
    }

    public function media()
    {
        return $this->hasOne('App\Models\Media');
    }

    public function role()
    {
        return $this->belongsTo('App\Models\Role');
    }

}